<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.19/dist/sweetalert2.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" />

  
  <div id="ordered_products" class="mt-4">
   
  <div class="mb-3">
        <div class="grid grid-cols-1 gap-4">
            <div class="row">
                <div class="col-lg-12 mb-3">
                    <x-input type="hidden" value="{{$studentWithMarks->id}}" id="student_id" class="bg-gray-200" readonly />
                    <strong> Name : </strong> {{$studentWithMarks->name}} 
                    <strong> Roll No : </strong> {{$studentWithMarks->roll_no}}                     
                    <strong> Class : </strong> {{$currentClass}}                     
                    <strong> Section : </strong> {{$currentSection}}                     
                    <strong> Session : </strong> {{$currentSession}}                     
                </div>

                <x-alert-danger id="__alertDangerEditShipmentForOrder" class="alert mb-5 hidden">
                    <div id="__alertDangerContentEditShipmentForOrder"></div>
                </x-alert-danger>

                <div class="col-lg-3">
                    <x-label for="__pending_stockCreateShipment">
                    {{ __('translation.Exam Name') }} <x-form.required-mark/>
                    </x-label>
                    <div class="form-group">
                        <x-select class="form-control relative top-1" id="exam_id" name="exam_id">
                            @if (isset($exams))
                                @foreach ($exams as $exam)
                                  <option value="{{$exam->id}}" @if($exam->id==$studentWithMarks->MarksDetails[0]->exam_id) selected @endif>
                                    {{$exam->exam_name}}</option>
                                @endforeach
                            @endif
                        </x-select>
                    </div>
                </div>

                <div class="col-lg-3">
                    <x-label for="__pending_stockCreateShipment">
                    {{ __('translation.Session') }} <x-form.required-mark/>
                    </x-label>
                    <div class="form-group">
                        <x-select class="form-control relative top-1" id="session_id" name="session_id">
                            @if (isset($sessions))
                                @foreach ($sessions as $session)
                                  <option value="{{$session->id}}">{{$session->session_name}}</option>
                                @endforeach
                            @endif
                        </x-select>
                    </div>
                </div>

                <div class="col-lg-3">
                    <x-label for="__pending_stockCreateShipment">
                    {{ __('translation.Class') }} <x-form.required-mark/>
                    </x-label>
                    <div class="form-group">
                        <x-select class="form-control relative top-1" id="class_id" name="class_id">
                        @if (isset($classes))
                            @foreach ($classes as $class)
                              <option value="{{$class->id}}">{{$class->class_name}}</option>
                            @endforeach
                        @endif
                        </x-select>
                    </div>
                </div>
                <div class="col-lg-3">
                    <x-label for="__shipment_dateCreateShipment">
                        {{ __('translation.Section') }}
                    </x-label>
                    <x-select class="form-control relative top-1" id="section_id" name="section_id">
                        @if (isset($sections))
                            @foreach ($sections as $section)
                              <option value="{{$section->id}}">{{$section->section_name}}</option>
                            @endforeach
                        @endif
                        </x-select>
                </div>
            </div>
            <div id="__pending_stock_info_wrapperCreateShipment" class="hidden">
                <p class="text-yellow-600 mb-0">
                    The status of the this order will change to <span class="font-bold">Waiting for Stock</span>.
                </p>
            </div>
        </div>
    </div>

     <table class="table table-responsive">
       <thead class="thead-light">
        <tr>
         <th class="text-center">SL</th>
         <th class="text-center">NAME</th>
         <th class="text-center">FULL MARKS</th>
         @if(!empty($mark_types))      
          @foreach($mark_types as $id=>$name)       
            <th class="text-center">{{ $name }}</th>
          @endforeach 
         @endif 
         <th class="text-center">TOTAL</th>
         <th class="text-center">GPA</th>
         <th class="text-center">GRADE</th>
       </tr>
     </thead>
     <tbody class="table-body new_products_table" id="new_products_table_for_edit">
      
      @if(!empty($studentWithMarks->MarksDetails))
      @php $i=1 @endphp
      @foreach($studentWithMarks->MarksDetails as $row)
      
      <tr class="new" id="product_{{($row->id)}}">
        <input type="hidden" name="student_id" value="{{($row->student_id)}}">
        <td class="text-center"> {{ $i }} </td>
        <td class="text-center"> {{ $subjects_id_name_Arr[$row->subject_id] }}  </td>
        <td class="text-center"> {{ $row->fullmarks }}  </td>         
        <?php 
        $type = explode(",",$row->mark_type_ids);
        $marks = explode(",",$row->marks);
        $combine = array_combine($type, $marks);
        $total = 0; 
        $total = array_sum($combine);
        ?>
        @if(!empty($mark_types))      
          @foreach($mark_types as $id=>$name)       
            <td class="text-center">@if(isset($combine[$id])) {{ $combine[$id] }} @endif</td>
          @endforeach 
         @endif 

        <td class="text-center"> {{$total}}  </td>

          @php
              $gpa = \App\Models\Marks::PerSubjectGPAGeneratorByTotal($total);
              if($gpa=='0') { 
                $color="red";
              } else{
                $color="#000";
              }
          @endphp
                                
            

        <td class="text-center" style="color:{{$color}}"> 
          {{$gpa}} 
        </td>
        <td class="text-center"  style="color:{{$color}}"> 
          @php
              $letter_grade = \App\Models\Marks::PerSubjectLetterGradeGeneratorByTotal($total);
          @endphp
                                
           {{$letter_grade}}  </td>
      </tr>
      @php $i++ @endphp
      @endforeach 
      <tr class="no_marks_wrapper">
        <td class="text-left" colspan=7><strong>TOTAL</strong></td>
        <td class="text-center"><strong>{{$GPA}}</strong></td>
          @php
            $letter_grade_by_total_gpa = \App\Models\Marks::PerSubjectLetterGradeGeneratorByGPA($GPA);
          @endphp

        <td class="text-center"><strong>{{$letter_grade_by_total_gpa}}</strong></td>
      </tr>


      @else
      <tr class="no_marks_wrapper">
         <td colspan="8" class="text-center">
         {{__('translation.No added Mark Yet')}}
         </td>
       </tr>
      @endif 
       
     </tbody>
  </table>
  </div>

<script type="text/javascript">




</script>




